package examples.entity.uni.many_to_one.client;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import examples.entity.uni.many_to_one.Employee;
import examples.entity.uni.many_to_one.interfaces.EmployeeAddressMOUni;


public class EmployeeAddressClient {
	public static void main(String[] args) {
		try {
			InitialContext ic = new InitialContext();
			EmployeeAddressMOUni ea = (EmployeeAddressMOUni)ic.lookup(EmployeeAddressMOUni.class.getName());
			
			ea.doSomeStuff();
			
			for (Object o : ea.getEmployees()) {
				Employee e = (Employee)o;
				System.out.println("Name: "+e.getName()+", Business Address: "+
						e.getAddress().getCity()+", "+e.getAddress().getZipcode());
			}
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
